/*
 * Decompiled with CFR 0.152.
 */
package ProcesadorDocumentos.XMLHelpers;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.InfoFiltro;
import ProcesadorDocumentos.XMLHelpers.SAXDocParser;
import Z3.Signature.Firmador;
import Z3.Signature.Verificador;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class documentWrapper
extends ContainerItem {
    protected String DocType = null;
    protected String Version = null;
    private Hashtable filter;
    private documentWrapper oldVersion = null;

    public documentWrapper() {
    }

    public documentWrapper(String DocType, String Version) {
        super.setDocument(this);
        this.DocType = DocType;
        this.Version = Version;
    }

    public documentWrapper(String DocType, String Version, ContainerItem fromItem) {
        super.setDocument(this);
        this.DocType = DocType;
        this.Version = Version;
        this.setAttributes(fromItem.getAttributes());
        this.setContainers(fromItem.getContainers());
    }

    public documentWrapper(String DocType, String Version, Date CreationDate) {
        super.setDocument(this);
        this.DocType = DocType;
        this.Version = Version;
    }

    public documentWrapper(File F) throws Exception {
        super.setDocument(this);
        FileReader fr = new FileReader(F);
        char[] c = new char[(int)F.length()];
        fr.read(c, 0, c.length);
        fr.close();
        String XML = new String(c);
        byte[] buf = XML.getBytes();
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse((InputStream)new ByteArrayInputStream(buf), (DefaultHandler)new SAXDocParser(this));
    }

    public documentWrapper(String XML) throws Exception {
        super.setDocument(this);
        DocumentBuilder DocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        byte[] buf = XML.getBytes();
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse((InputStream)new ByteArrayInputStream(buf), (DefaultHandler)new SAXDocParser(this));
    }

    public documentWrapper(ContainerItem fromItem, String DocType, String Version) throws Exception {
        super.setDocument(this);
        this.DocType = DocType;
        this.Version = Version;
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        b.append("<Documento tipo=\"" + this.DocType + "\" version=\"" + this.Version + "\">\n");
        b.append(fromItem.toXML(2));
        b.append("</Documento>\n");
        String XML = b.toString();
        DocumentBuilder DocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        byte[] buf = XML.getBytes();
        Document Doc = DocBuilder.parse(new ByteArrayInputStream(buf));
        this.fromXML(Doc);
    }

    public Object clone() {
        return new documentWrapper(this.getDocType(), this.getVersion(), this);
    }

    public String getDocType() {
        return this.DocType;
    }

    public String getVersion() {
        return this.Version;
    }

    public documentWrapper(Document D) throws Exception {
        this.fromXML(D);
    }

    public void saveToFile(File F) throws Exception {
        FileWriter FW = new FileWriter(F);
        FW.write(this.toXML());
        FW.close();
    }

    public File saveToTmpFile() throws Exception {
        File tmpFile = File.createTempFile("doc", null);
        this.saveToFile(tmpFile);
        return tmpFile;
    }

    public void setFilter(documentWrapper DocFiltro) {
        if (DocFiltro == null) {
            return;
        }
        this.filter = new Hashtable();
        AttrContainer contFiltros = DocFiltro.getContainer("filtros");
        if (contFiltros != null) {
            int i = 0;
            while (i < contFiltros.size()) {
                ContainerItem filtro = contFiltros.getItem(i);
                InfoFiltro infoFiltro = new InfoFiltro(filtro);
                this.filter.put(infoFiltro.getNombre(), infoFiltro);
                ++i;
            }
        }
    }

    public String toXML() {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        b.append("<Documento tipo=\"" + this.DocType + "\" version=\"" + this.Version + "\">\n");
        b.append(this.toXML(2));
        b.append("</Documento>\n");
        return b.toString();
    }

    public void fromXML(Document D) throws Exception {
        Element root = D.getDocumentElement();
        NamedNodeMap Attributes2 = root.getAttributes();
        this.DocType = root.getAttribute("tipo");
        this.Version = root.getAttribute("version");
        this.fromXMLNode(root);
    }

    public String toXMLOnlyData() {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        b.append("<Documento tipo=\"" + this.DocType + "\" version=\"" + this.Version + "\">\n");
        b.append(this.toXMLOnlyData(2));
        b.append("</Documento>\n");
        return b.toString();
    }

    public void firma(String firmante, Firmador f) throws Exception {
        String xmlOnlyData = this.toXMLOnlyData();
        byte[] firma = f.Firmar("RSA", xmlOnlyData);
        String Firma64 = documentWrapper.encode64(firma);
        AttrContainer Firmas = this.getContainer("Firmas");
        if (Firmas == null) {
            Firmas = this.addContainer("Firmas", "firma");
        }
        ContainerItem itemFirma = Firmas.addItem();
        itemFirma.setAttribute("firmante", firmante);
        itemFirma.setAttribute("firma-digital", Firma64);
    }

    public boolean verificaFirma(String firmante, Verificador v) throws Exception {
        AttrContainer Firmas = this.getContainer("Firmas");
        if (Firmas == null) {
            throw new Exception("El documento no ha sido firmado");
        }
        ContainerItem firmaBuscada = null;
        Enumeration Enum2 = Firmas.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem f = (ContainerItem)Enum2.nextElement();
            if (!f.getAttribute("firmante").equals(firmante)) continue;
            firmaBuscada = f;
        }
        if (firmaBuscada == null) {
            throw new Exception("Firmante no encontrado en el documento");
        }
        String xmlOnlyData = this.toXMLOnlyData();
        return v.Validar("RSA", xmlOnlyData, documentWrapper.decode64(firmaBuscada.getAttribute("firma-digital")));
    }

    public String getFirma64(String firmante) {
        AttrContainer Firmas = this.getContainer("Firmas");
        if (Firmas == null) {
            return null;
        }
        ContainerItem firmaBuscada = null;
        Enumeration Enum2 = Firmas.getItems();
        while (Enum2.hasMoreElements()) {
            ContainerItem f = (ContainerItem)Enum2.nextElement();
            if (!f.getAttribute("firmante").equals(firmante)) continue;
            firmaBuscada = f;
        }
        if (firmaBuscada == null) {
            return null;
        }
        return firmaBuscada.getAttribute("firma-digital");
    }

    public static String encode64(byte[] st) throws Exception {
        return new BASE64Encoder().encodeBuffer(st);
    }

    public static byte[] decode64(String st) throws Exception {
        return new BASE64Decoder().decodeBuffer(st);
    }

    public void setFilter(Hashtable f) {
        this.filter = f;
    }

    public Hashtable getFilter() {
        return this.filter;
    }

    public InfoFiltro searchFilter(String nombreFiltro) {
        Enumeration enumeration = this.filter.elements();
        while (enumeration.hasMoreElements()) {
            InfoFiltro f = (InfoFiltro)enumeration.nextElement();
            if (!f.getNombre().equals(nombreFiltro)) continue;
            return f;
        }
        return null;
    }

    public void activateVersionning() throws Exception {
        AttrContainer versiones = this.getVersiones();
        this.oldVersion = versiones == null ? new documentWrapper(this.toXMLOnlyData()) : new documentWrapper(this.rebuildVersion(versiones.size()).toXMLOnlyData());
    }

    public void activateVersionning(documentWrapper compareTo) throws Exception {
        this.oldVersion = new documentWrapper(compareTo.toXMLOnlyData());
    }

    public void saveVersionInfo() throws Exception {
        this.saveVersionInfo((byte[])null, null, null, null);
    }

    public void saveVersionInfo(String login, String nombre, String descripcionVersion) throws Exception {
        this.saveVersionInfo((byte[])null, login, nombre, descripcionVersion);
    }

    public void saveVersionInfo(Firmador firmador, String loginFirmante, String nombreFirmante, String descripcionVersion) throws Exception {
        AttrContainer versiones = this.getContainer("versiones");
        if (versiones == null) {
            versiones = this.addContainer("versiones", "version");
        }
        ContainerItem version = versiones.addItem();
        Date ahora = Calendar.getInstance().getTime();
        version.setDateTimeAttribute("fecha-hora", ahora);
        AttrContainer changes = version.addContainer("control-cambios", "cambio");
        String onlyData = this.toXMLOnlyData();
        this.compareVersion(new documentWrapper(onlyData), this.oldVersion, changes);
        if (descripcionVersion != null) {
            version.setAttribute("descripcion", descripcionVersion);
        }
        if (firmador != null) {
            byte[] firma = firmador.Firmar("RSA", onlyData);
            String firma64 = documentWrapper.encode64(firma);
            version.setAttribute("firma", firma64);
        }
        if (loginFirmante != null) {
            version.setAttribute("id-firmante", loginFirmante);
        }
        if (nombreFirmante != null) {
            version.setAttribute("nombre-firmante", nombreFirmante);
        }
    }

    public void saveVersionInfo(byte[] firma, String loginFirmante, String nombreFirmante, String descripcionVersion) throws Exception {
        AttrContainer versiones = this.getContainer("versiones");
        if (versiones == null) {
            versiones = this.addContainer("versiones", "version");
        }
        ContainerItem version = versiones.addItem();
        Date ahora = Calendar.getInstance().getTime();
        version.setDateTimeAttribute("fecha-hora", ahora);
        AttrContainer changes = version.addContainer("control-cambios", "cambio");
        String onlyData = this.toXMLOnlyData();
        this.compareVersion(new documentWrapper(onlyData), this.oldVersion, changes);
        if (descripcionVersion != null) {
            version.setAttribute("descripcion", descripcionVersion);
        }
        if (firma != null) {
            String firma64 = documentWrapper.encode64(firma);
            version.setAttribute("firma", firma64);
        }
        if (loginFirmante != null) {
            version.setAttribute("id-firmante", loginFirmante);
        }
        if (nombreFirmante != null) {
            version.setAttribute("nombre-firmante", nombreFirmante);
        }
    }

    public documentWrapper rebuildVersion(int nVersion) throws Exception {
        ContainerItem itemVersion = new documentWrapper(this.toXMLOnlyData());
        AttrContainer versiones = this.getContainer("versiones");
        if (versiones == null) {
            versiones = this.addContainer("versiones", "version");
        }
        int i = versiones.size() - 1;
        while (i >= nVersion) {
            ContainerItem cambiosVersion = versiones.getItem(i);
            itemVersion = this.reversaCambios(itemVersion, cambiosVersion);
            --i;
        }
        return new documentWrapper(itemVersion, this.getDocType(), this.getVersion());
    }

    public AttrContainer getVersiones() {
        return this.getContainer("versiones");
    }

    public int getNumeroVersiones() {
        AttrContainer versiones = this.getVersiones();
        if (versiones == null) {
            return 0;
        }
        return versiones.size();
    }

    public void setXMLOnlyData(documentWrapper doc) throws Exception {
        documentWrapper docOnlyData = new documentWrapper(doc.toXMLOnlyData());
        Enumeration<?> props = this.getAttributes().propertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            this.unsetAttribute(propName);
        }
        Enumeration keys = this.getContainers().keys();
        while (keys.hasMoreElements()) {
            boolean esDeControl;
            String k = (String)keys.nextElement();
            boolean bl = esDeControl = k.equals("Control") || k.equals("Firmas") || k.equals("versiones") || k.equals("workflow");
            if (esDeControl) continue;
            this.removeContainer(k);
        }
        this.copyFromItem(docOnlyData);
    }

    public String encripta(String pwd) throws Exception {
        try {
            MessageDigest MD = MessageDigest.getInstance("SHA");
            byte[] bytes = this.toXML().getBytes();
            MD.update(pwd.getBytes());
            byte[] hash = MD.digest();
            int n = 0;
            int i = 0;
            while (i < bytes.length) {
                byte b = hash[n];
                n = n == 19 ? 0 : n + 1;
                bytes[i] = (byte)(bytes[i] ^ b);
                ++i;
            }
            return documentWrapper.encode64(bytes);
        }
        catch (Exception E) {
            E.printStackTrace();
            throw E;
        }
    }

    public static documentWrapper desencripta(String pwd, String txt) throws Exception {
        try {
            MessageDigest MD = MessageDigest.getInstance("SHA");
            byte[] bytes = documentWrapper.decode64(txt);
            MD.update(pwd.getBytes());
            byte[] hash = MD.digest();
            int n = 0;
            int i = 0;
            while (i < bytes.length) {
                byte b = hash[n];
                n = n == 19 ? 0 : n + 1;
                bytes[i] = (byte)(bytes[i] ^ b);
                ++i;
            }
            return new documentWrapper(new String(bytes));
        }
        catch (Exception E) {
            E.printStackTrace();
            throw E;
        }
    }
}

