/*
 * Decompiled with CFR 0.152.
 */
package tif.schema.impl.runtime;

import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.util.AttributesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import tif.schema.impl.runtime.GrammarInfo;
import tif.schema.impl.runtime.SAXUnmarshallerHandler;
import tif.schema.impl.runtime.UnmarshallerImpl;
import tif.schema.impl.runtime.UnmarshallingContext;
import tif.schema.impl.runtime.UnmarshallingEventHandler;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private final GrammarInfo grammarInfo;
    private Object result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private AttributesImpl[] attStack = new AttributesImpl[16];
    private int elementDepth;
    private int stackTop;
    private boolean[] collectText = new boolean[16];
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator = DUMMY_LOCATOR;
    private static final Locator DUMMY_LOCATOR = new LocatorImpl();
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl _parent, GrammarInfo _gi) {
        this.parent = _parent;
        this.grammarInfo = _gi;
        this.startPrefixMapping("", "");
    }

    @Override
    public GrammarInfo getGrammarInfo() {
        return this.grammarInfo;
    }

    private final boolean shouldCollectText() {
        return this.collectText[this.stackTop];
    }

    @Override
    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.stackTop = 0;
        this.elementDepth = 1;
    }

    @Override
    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes atts) throws SAXException {
        if (uri == null) {
            uri = "";
        }
        if (local == null || local.length() == 0) {
            local = qname;
        }
        if (qname == null || qname.length() == 0) {
            qname = local;
        }
        if (this.result == null) {
            UnmarshallingEventHandler unmarshaller = this.grammarInfo.createUnmarshaller(uri, local, this);
            if (unmarshaller == null) {
                throw new SAXParseException(Messages.format("SAXUnmarshallerHandlerImpl.UnexpectedRootElement2", uri, local, this.computeExpectedRootElements()), this.getLocator());
            }
            this.result = unmarshaller.owner();
            this.pushContentHandler(unmarshaller, 0);
        }
        this.processText(true);
        this.getCurrentHandler().enterElement(uri, local, qname, atts);
    }

    @Override
    public final void endElement(String uri, String local, String qname) throws SAXException {
        if (uri == null) {
            uri = "";
        }
        if (local == null || local.length() == 0) {
            local = qname;
        }
        if (qname == null || qname.length() == 0) {
            qname = local;
        }
        this.processText(false);
        this.getCurrentHandler().leaveElement(uri, local, qname);
    }

    @Override
    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException(null);
    }

    @Override
    public void pushContentHandler(UnmarshallingEventHandler handler, int memento) {
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] h = new UnmarshallingEventHandler[this.handlerLen * 2];
            int[] m = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, h, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, m, 0, this.handlerLen);
            this.handlers = h;
            this.mementos = m;
        }
        this.handlers[this.handlerLen] = handler;
        this.mementos[this.handlerLen] = memento;
        ++this.handlerLen;
    }

    @Override
    public void popContentHandler() throws SAXException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    @Override
    public UnmarshallingEventHandler getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String str, boolean ignorable) throws SAXException {
        if (ignorable && str.trim().length() == 0) {
            return;
        }
        this.getCurrentHandler().text(str);
    }

    private void processText(boolean ignorable) throws SAXException {
        if (this.shouldCollectText()) {
            this.consumeText(this.buffer.toString(), ignorable);
        }
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public final void characters(char[] buf, int start, int len) {
        if (this.shouldCollectText()) {
            this.buffer.append(buf, start, len);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        int i = this.idxStack[this.stackTop] - 2;
        while (i >= 0) {
            if (prefix.equals(this.nsBind[i])) {
                return this.nsBind[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    @Override
    public String[] getNewlyDeclaredPrefixes() {
        return this.getPrefixList(this.idxStack[this.stackTop - 1]);
    }

    @Override
    public String[] getAllDeclaredPrefixes() {
        return this.getPrefixList(2);
    }

    private String[] getPrefixList(int startIndex) {
        int size = (this.idxStack[this.stackTop] - startIndex) / 2;
        String[] r = new String[size];
        int i = 0;
        while (i < r.length) {
            r[i] = this.nsBind[startIndex + i * 2];
            ++i;
        }
        return r;
    }

    @Override
    public Iterator getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List getAllPrefixesInList(String uri) {
        ArrayList<String> a = new ArrayList<String>();
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a.add("xml");
            return a;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a.add("xmlns");
            return a;
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        int i = this.nsLen - 2;
        while (i >= 0) {
            if (uri.equals(this.nsBind[i + 1]) && this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) {
                a.add(this.nsBind[i]);
            }
            i -= 2;
        }
        return a;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        int i = this.idxStack[this.stackTop] - 2;
        while (i >= 0) {
            if (uri.equals(this.nsBind[i + 1]) && this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) {
                return this.nsBind[i];
            }
            i -= 2;
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.resolveNamespacePrefix(prefix);
    }

    @Override
    public void pushAttributes(Attributes atts, boolean collectTextFlag) {
        if (this.attStack.length == this.elementDepth) {
            AttributesImpl[] buf1 = new AttributesImpl[this.attStack.length * 2];
            System.arraycopy(this.attStack, 0, buf1, 0, this.attStack.length);
            this.attStack = buf1;
            int[] buf2 = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, buf2, 0, this.idxStack.length);
            this.idxStack = buf2;
            boolean[] buf3 = new boolean[this.collectText.length * 2];
            System.arraycopy(this.collectText, 0, buf3, 0, this.collectText.length);
            this.collectText = buf3;
        }
        ++this.elementDepth;
        ++this.stackTop;
        AttributesImpl a = this.attStack[this.stackTop];
        if (a == null) {
            this.attStack[this.stackTop] = a = new AttributesImpl();
        } else {
            a.clear();
        }
        int i = 0;
        while (i < atts.getLength()) {
            String v;
            String auri = atts.getURI(i);
            String alocal = atts.getLocalName(i);
            String avalue = atts.getValue(i);
            String aqname = atts.getQName(i);
            if (auri == null) {
                auri = "";
            }
            if (alocal == null || alocal.length() == 0) {
                alocal = aqname;
            }
            if (aqname == null || aqname.length() == 0) {
                aqname = alocal;
            }
            if (auri != "http://www.w3.org/2001/XMLSchema-instance" || alocal != "nil" || !(v = avalue.trim()).equals("false") && !v.equals("0")) {
                a.addAttribute(auri, alocal, aqname, atts.getType(i), avalue);
            }
            ++i;
        }
        this.idxStack[this.stackTop] = this.nsLen;
        this.collectText[this.stackTop] = collectTextFlag;
    }

    @Override
    public void popAttributes() {
        --this.stackTop;
        --this.elementDepth;
    }

    @Override
    public Attributes getUnconsumedAttributes() {
        return this.attStack[this.stackTop];
    }

    @Override
    public int getAttribute(String uri, String local) {
        return this.attStack[this.stackTop].getIndexFast(uri, local);
    }

    @Override
    public void consumeAttribute(int idx) throws SAXException {
        AttributesImpl a = this.attStack[this.stackTop];
        String uri = a.getURI(idx);
        String local = a.getLocalName(idx);
        String qname = a.getQName(idx);
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        this.getCurrentHandler().enterAttribute(uri, local, qname);
        this.consumeText(value, false);
        this.getCurrentHandler().leaveAttribute(uri, local, qname);
    }

    @Override
    public String eatAttribute(int idx) throws SAXException {
        AttributesImpl a = this.attStack[this.stackTop];
        String value = a.getValue(idx);
        a.removeAttribute(idx);
        return value;
    }

    @Override
    public void addPatcher(Runnable job) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] buf = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            int i = 0;
            while (i < this.patchersLen) {
                this.patchers[i].run();
                ++i;
            }
        }
    }

    @Override
    public String addToIdTable(String id) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(id, this.getCurrentHandler().owner());
        return id;
    }

    @Override
    public Object getObjectFromId(String id) {
        if (this.idmap == null) {
            return null;
        }
        return this.idmap.get(id);
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void handleEvent(ValidationEvent event, boolean canRecover) throws SAXException {
        ValidationEventHandler eventHandler;
        try {
            eventHandler = this.parent.getEventHandler();
        }
        catch (JAXBException e) {
            throw new JAXBAssertionError();
        }
        boolean recover = eventHandler.handleEvent(event);
        if (!recover) {
            this.aborted = true;
        }
        if (!canRecover || !recover) {
            throw new SAXException(new UnmarshalException(event.getMessage(), event.getLinkedException()));
        }
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public boolean isUnparsedEntity(String s) {
        return true;
    }

    @Override
    public boolean isNotation(String s) {
        return true;
    }

    public void setTracer(Tracer t) {
        this.tracer = t;
    }

    @Override
    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }

    private String computeExpectedRootElements() {
        String r = "";
        String[] probePoints = this.grammarInfo.getProbePoints();
        int i = 0;
        while (i < probePoints.length) {
            if (this.grammarInfo.recognize(probePoints[i], probePoints[i + 1])) {
                if (r.length() != 0) {
                    r = String.valueOf(r) + ',';
                }
                r = String.valueOf(r) + "<{" + probePoints[i] + "}" + probePoints[i + 1] + ">";
            }
            i += 2;
        }
        return r;
    }
}

